class Pickup_Dollar extends MercWarriorsPickup;

#exec mesh import mesh=Pickup_Dollar anivfile=Models\Pickup_Dollar_a.3d datafile=Models\Pickup_Dollar_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Pickup_Dollar x=0 y=0 z=0
#exec mesh sequence mesh=Pickup_Dollar seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Pickup_Dollar mesh=Pickup_Dollar
//#exec meshmap scale meshmap=Pickup_Dollar x=0.13281 y=0.13281 z=0.26563 	//original size
#exec meshmap scale meshmap=Pickup_Dollar x=0.066405 y=0.066405 z=0.132815	//half size

var int NumDollars;

auto state Pickup
{	
	function Touch( actor Other )
		{
		local Inventory Copy;
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn') ) 
			{
			//Copy = SpawnCopy(Pawn(Other));
			Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
			PlaySound (PickupSound,,2.0);	
			//Pickup(Copy).PickupFunction(Pawn(Other));
			MW_PRI(PlayerPawn(Other).PlayerReplicationInfo).Money += NumDollars;
			SetRespawn();
			}
		}

	function BeginState()
	{
		Super.BeginState();
		NumCopies = 0;
	}
}

defaultproperties
{
  NumDollars=5
  ItemColor=(R=200,G=200,B=0)
  RespawnTime=0
  DrawType=DT_Mesh
  Mesh=Mesh'Pickup_Dollar'
  bCollideWhenPlacing=True
  bCollideActors=True
  bCollideWorld=True
  bBlockActors=True
  bBlockPlayers=True
  CollisionRadius=17.00000
  CollisionHeight=17.00000
  MultiSkins(0)=Texture'UnrealShare.GoldSkin'
  MultiSkins(1)=Texture'MercWarriors.HUD.Icon_Dollar'
  PickupMessage="You picked up a few dollars."
  ItemName="A few dollars."
  PickupViewMesh=Mesh'Pickup_Dollar'
  bCollideWhenPlacing=True
  bRotatingPickup=True
  RotationRate=(Roll=12500)
  RotationRate=(Pitch=12250)
  RotationRate=(Yaw=12000)
  RespawnTime=0.000000
}
